import processing.opengl.*;
import codeanticode.glgraphics.*;

side l;
side r;
ArrayList <player> players = new ArrayList();
ArrayList <side> sides = new ArrayList();


void setup() {
  size(600, 300, GLConstants.GLGRAPHICS); 
  hint(DISABLE_OPENGL_2X_SMOOTH);
  frameRate(60);
  frame.setResizable(true);

  l = new side(new PVector(0, 0));
  r = new side(new PVector(300, 0));
  players.add(l.p);
  players.add(r.p);
  sides.add(l);
  sides.add(r);
}

void draw() {
  background(0);

  for (player p: players) {

    if (p.up) p.move(1);
    if (p.down) p.move(2);
    if (p.left) p.move(3);
    if (p.right) p.move(4);
    if (p.fire && p.parent == l) p.fire(r);
    if (p.fire && p.parent == r) p.fire(l);


    for (bullet b: p.bullets) {
      if (b.pos.equals(p.pos)) {
        reset();
        break;
      }
    }
  }

  for (side s: sides) {
    s.render();
  }
}

void reset(){

l.p.bullets.clear();
r.p.bullets.clear();
  
}

void keyPressed() {

  switch(keyCode) {
  case UP:
    r.p.up = true;
    break;
  case DOWN:
    r.p.down = true;
    break;
  case LEFT:
    r.p.left = true;
    break;
  case RIGHT:
    r.p.right = true;
    break;
  case ENTER:
    r.p.fire = true;
    break;
  } 

  switch(key) {
  case 'w':
    l.p.up = true;
    break;
  case 's':
    l.p.down = true;
    break;
  case 'a':
    l.p.left = true;
    break;
  case 'd':
    l.p.right = true;
    break;
  case 'z':
    l.p.fire = true;
    break;
  }
}

void keyReleased() {

  switch(keyCode) {
  case UP:
    r.p.up = false;
    break;
  case DOWN:
    r.p.down = false;
    break;
  case LEFT:
    r.p.left = false;
    break;
  case RIGHT:
    r.p.right = false;
    break;
  case ENTER:
    r.p.fire = false;
    break;
  } 

  switch(key) {
  case 'w':
    l.p.up = false;
    break;
  case 's':
    l.p.down = false;
    break;
  case 'a':
    l.p.left = false;
    break;
  case 'd':
    l.p.right = false;
    break;
  case 'z':
    l.p.fire = false;
    break;
  }
}

